package com.burhanstore.neonbubblequest.Utils.monetize

import android.annotation.SuppressLint
import android.app.Activity
import android.util.Log
import android.widget.Toast
import com.inmobi.ads.AdMetaInfo
import com.inmobi.ads.InMobiAdRequestStatus
import com.inmobi.ads.InMobiInterstitial
import com.inmobi.ads.listeners.InterstitialAdEventListener
import com.inmobi.sdk.InMobiSdk
import com.inmobi.sdk.SdkInitializationListener
import org.json.JSONObject

object InMobi_Ad {

    private const val TAG = "InMobi_Ad"
    private var interstitialAd: InMobiInterstitial? = null
    private var isInitialized = false
    private var isAdLoaded = false

    private const val sdkPlacementId: Long = 234423423423
    private const val adPlacementId: Long = 432423432

    @SuppressLint("Range")
    fun initialize(activity: Activity, onInitialized: (() -> Unit)? = null) {
        if (isInitialized) {
            onInitialized?.invoke()
            return
        }

        val consentObject = JSONObject().apply {
            put(InMobiSdk.IM_GDPR_CONSENT_AVAILABLE, true)
            put("gdpr", "0")
            put(InMobiSdk.IM_GDPR_CONSENT_IAB, "<YOUR_CONSENT_STRING>")
        }

        InMobiSdk.init(activity, sdkPlacementId.toString(), consentObject, object : SdkInitializationListener {
            override fun onInitializationComplete(error: Error?) {
                if (error != null) {
                    Log.e(TAG, "InMobi SDK init failed: $error")
                    Toast.makeText(activity, "InMobi Init Failed", Toast.LENGTH_SHORT).show()
                } else {
                    isInitialized = true
                    Log.d(TAG, "InMobi SDK initialized")
                    Toast.makeText(activity, "InMobi SDK Initialized", Toast.LENGTH_SHORT).show()
                    onInitialized?.invoke()
                    loadRewardedAd(activity)
                }
            }
        })
    }

    fun loadRewardedAd(activity: Activity) {
        if (!isInitialized) return

        isAdLoaded = false
        interstitialAd = InMobiInterstitial(activity, adPlacementId, object : InterstitialAdEventListener() {

            override fun onAdDisplayed(ad: InMobiInterstitial, info: AdMetaInfo) {
                Log.d(TAG, "Ad displayed")
            }

            override fun onAdDismissed(ad: InMobiInterstitial) {
                Log.d(TAG, "Ad dismissed")
                isAdLoaded = false
                loadRewardedAd(activity) // auto reload
            }

            override fun onRewardsUnlocked(ad: InMobiInterstitial, rewards: Map<Any, Any>) {
                Log.d(TAG, "Rewards unlocked: $rewards")
            }

            fun onAdClicked(ad: InMobiInterstitial) {
                Log.d(TAG, "Ad clicked")
            }

            fun onAdFetchSuccessful(ad: InMobiInterstitial) {
                isAdLoaded = true
                Log.d(TAG, "Ad fetched successfully")
            }

            override fun onAdFetchFailed(ad: InMobiInterstitial, status: InMobiAdRequestStatus) {
                isAdLoaded = false
                Log.e(TAG, "Ad fetch failed: $status")
            }
        })

        interstitialAd?.load()
    }

    fun showRewardedAd(
        activity: Activity,
        onAdComplete: (() -> Unit)? = null,
        onAdFailed: (() -> Unit)? = null,
        onAdClicked: (() -> Unit)? = null
    ) {
        if (interstitialAd != null && isAdLoaded && interstitialAd!!.isReady()) {
            interstitialAd!!.setListener(object : InterstitialAdEventListener() {

                override fun onAdDisplayed(ad: InMobiInterstitial, info: AdMetaInfo) {}
                override fun onAdDismissed(ad: InMobiInterstitial) {}
                fun onAdFetchSuccessful(ad: InMobiInterstitial) {}
                override fun onAdFetchFailed(ad: InMobiInterstitial, status: InMobiAdRequestStatus) {}

                fun onAdClicked(ad: InMobiInterstitial) {
                    Log.d(TAG, "User clicked the ad")
                    onAdClicked?.invoke()
                }

                override fun onRewardsUnlocked(ad: InMobiInterstitial, rewards: Map<Any, Any>) {
                    Log.d(TAG, "Reward unlocked")
                    onAdComplete?.invoke()
                }
            })

            interstitialAd!!.show()
        } else {
            Log.w(TAG, "Ad not ready")
            Toast.makeText(activity, "Ad not ready yet", Toast.LENGTH_SHORT).show()
            onAdFailed?.invoke()
            loadRewardedAd(activity)
        }
    }
}
